/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import processing.app.Base;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.RunnerException;

public class Sizer
implements MessageConsumer {
    private String buildPath;
    private String sketchName;
    private String firstLine;
    private long size;
    private RunnerException exception;

    public Sizer(String buildPath, String sketchName) {
        this.buildPath = buildPath;
        this.sketchName = sketchName;
    }

    public long computeSize() throws RunnerException {
        String avrBasePath = Base.getAvrBasePath();
        String[] commandSize = new String[]{avrBasePath + "avr-size", " "};
        commandSize[1] = this.buildPath + File.separator + this.sketchName + ".hex";
        int r = 0;
        try {
            this.exception = null;
            this.size = -1L;
            this.firstLine = null;
            Process process = Runtime.getRuntime().exec(commandSize);
            MessageSiphon in = new MessageSiphon(process.getInputStream(), this);
            MessageSiphon err = new MessageSiphon(process.getErrorStream(), this);
            boolean running = true;
            while (running) {
                try {
                    in.join();
                    err.join();
                    r = process.waitFor();
                    running = false;
                }
                catch (InterruptedException intExc) {}
            }
        }
        catch (Exception e) {
            this.exception = new RunnerException(e.toString() == null ? e.getClass().getName() + r : e.toString() + r);
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.size == -1L) {
            throw new RunnerException(this.firstLine);
        }
        return this.size;
    }

    public void message(String s) {
        if (this.firstLine == null) {
            this.firstLine = s;
        } else {
            StringTokenizer st = new StringTokenizer(s, " ");
            try {
                st.nextToken();
                st.nextToken();
                st.nextToken();
                this.size = new Integer(st.nextToken().trim()).longValue();
            }
            catch (NoSuchElementException e) {
                this.exception = new RunnerException(e.toString());
            }
            catch (NumberFormatException e) {
                this.exception = new RunnerException(e.toString());
            }
        }
    }
}

