/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.Preferences;
import processing.app.SerialException;
import processing.app.SketchCode;
import processing.app.debug.AvrdudeUploader;
import processing.app.debug.Compiler;
import processing.app.debug.RunnerException;
import processing.app.debug.Sizer;
import processing.app.debug.Uploader;
import processing.app.preproc.PdePreprocessor;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sketch {
    private static File tempBuildFolder;
    private Editor editor;
    private File primaryFile;
    private String name;
    private boolean modified;
    private File folder;
    private File dataFolder;
    private File codeFolder;
    private SketchCode current;
    private int currentIndex;
    private int codeCount;
    private SketchCode[] code;
    private String appletClassName;
    private String classPath;
    private String libraryPath;
    private ArrayList<File> importedLibraries;
    boolean renamingCode;
    private static boolean deleteFilesOnNextBuild;
    private static List<String> hiddenExtensions;

    public Sketch(Editor editor, String path) throws IOException {
        this.editor = editor;
        this.primaryFile = new File(path);
        String mainFilename = this.primaryFile.getName();
        int suffixLength = this.getDefaultExtension().length() + 1;
        this.name = mainFilename.substring(0, mainFilename.length() - suffixLength);
        tempBuildFolder = Base.getBuildFolder();
        this.folder = new File(new File(path).getParent());
        this.load();
    }

    protected void load() {
        this.codeFolder = new File(this.folder, "code");
        this.dataFolder = new File(this.folder, "data");
        String[] list = this.folder.list();
        this.codeCount = 0;
        this.code = new SketchCode[list.length];
        String[] extensions = this.getExtensions();
        for (String filename : list) {
            if (filename.startsWith(".") || new File(this.folder, filename).isDirectory()) continue;
            String base = filename;
            for (String extension : extensions) {
                if (!base.toLowerCase().endsWith("." + extension) || !Sketch.isSanitaryName(base = base.substring(0, base.length() - (extension.length() + 1)))) continue;
                this.code[this.codeCount++] = new SketchCode(new File(this.folder, filename), extension);
            }
        }
        this.code = (SketchCode[])PApplet.subset((Object)this.code, (int)0, (int)this.codeCount);
        for (int i = 1; i < this.codeCount; ++i) {
            if (!this.code[i].getFile().equals(this.primaryFile)) continue;
            SketchCode temp = this.code[0];
            this.code[0] = this.code[i];
            this.code[i] = temp;
            break;
        }
        this.sortCode();
        if (this.editor != null) {
            this.setCurrentCode(0);
        }
    }

    protected void replaceCode(SketchCode newCode) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].getFileName().equals(newCode.getFileName())) continue;
            this.code[i] = newCode;
            break;
        }
    }

    protected void insertCode(SketchCode newCode) {
        this.ensureExistence();
        this.code = (SketchCode[])PApplet.append((Object)this.code, (Object)newCode);
        ++this.codeCount;
    }

    protected void sortCode() {
        for (int i = 1; i < this.codeCount; ++i) {
            int who = i;
            for (int j = i + 1; j < this.codeCount; ++j) {
                if (this.code[j].getFileName().compareTo(this.code[who].getFileName()) >= 0) continue;
                who = j;
            }
            if (who == i) continue;
            SketchCode temp = this.code[who];
            this.code[who] = this.code[i];
            this.code[i] = temp;
        }
    }

    public void handleNewCode() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage(I18n._("Sketch is Read-Only"), I18n._("Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again."));
            return;
        }
        this.renamingCode = false;
        this.editor.status.edit(I18n._("Name for new file:"), "");
    }

    public void handleRenameCode() {
        this.ensureExistence();
        if (this.currentIndex == 0 && this.editor.untitled) {
            Base.showMessage(I18n._("Sketch is Untitled"), I18n._("How about saving the sketch first \nbefore trying to rename it?"));
            return;
        }
        if (this.isReadOnly()) {
            Base.showMessage(I18n._("Sketch is Read-Only"), I18n._("Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again."));
            return;
        }
        this.renamingCode = true;
        String prompt = this.currentIndex == 0 ? "New name for sketch:" : "New name for file:";
        String oldName = this.current.isExtension("ino") ? this.current.getPrettyName() : this.current.getFileName();
        this.editor.status.edit(prompt, oldName);
    }

    protected void nameCode(String newName) {
        String sanitaryName;
        this.ensureExistence();
        if (newName.indexOf(46) == -1) {
            newName = newName + "." + this.getDefaultExtension();
        }
        if (this.renamingCode && newName.equalsIgnoreCase(this.current.getFileName())) {
            return;
        }
        if ((newName = newName.trim()).equals("")) {
            return;
        }
        int dot = newName.indexOf(46);
        if (dot == 0) {
            Base.showWarning(I18n._("Problem with rename"), I18n._("The name cannot start with a period."), null);
            return;
        }
        String newExtension = newName.substring(dot + 1).toLowerCase();
        if (!this.validExtension(newExtension)) {
            Base.showWarning(I18n._("Problem with rename"), I18n.format(I18n._("\".{0}\" is not a valid extension."), newExtension), null);
            return;
        }
        if (!this.isDefaultExtension(newExtension) && this.renamingCode && this.current == this.code[0]) {
            Base.showWarning(I18n._("Problem with rename"), I18n._("The main file can't use an extension.\n(It may be time for your to graduate to a\n\"real\" programming environment)"), null);
            return;
        }
        String shortName = newName.substring(0, dot);
        if (!shortName.equals(sanitaryName = Sketch.sanitizeName(shortName))) {
            newName = sanitaryName + "." + newExtension;
        }
        for (SketchCode c : this.code) {
            if (!newName.equalsIgnoreCase(c.getFileName())) continue;
            Base.showMessage(I18n._("Nope"), I18n.format(I18n._("A file named \"{0}\" already exists in \"{1}\""), c.getFileName(), this.folder.getAbsolutePath()));
            return;
        }
        if (newName.equals(this.getName() + ".cpp")) {
            Base.showMessage(I18n._("Nope"), I18n._("You can't have a .cpp file with the same name as the sketch."));
            return;
        }
        if (this.renamingCode && this.currentIndex == 0) {
            for (int i = 1; i < this.codeCount; ++i) {
                if (!sanitaryName.equalsIgnoreCase(this.code[i].getPrettyName()) || !this.code[i].getExtension().equalsIgnoreCase("cpp")) continue;
                Base.showMessage(I18n._("Nope"), I18n.format(I18n._("You can't rename the sketch to \"{0}\"\nbecause the sketch already has a .cpp file with that name."), sanitaryName));
                return;
            }
        }
        File newFile = new File(this.folder, newName);
        if (this.renamingCode) {
            if (this.currentIndex == 0) {
                String folderName = newName.substring(0, newName.indexOf(46));
                File newFolder = new File(this.folder.getParentFile(), folderName);
                if (newFolder.exists()) {
                    Base.showWarning(I18n._("Cannot Rename"), I18n.format(I18n._("Sorry, a sketch (or folder) named \"{0}\" already exists."), newName), null);
                    return;
                }
                if (this.current.isModified()) {
                    this.current.setProgram(this.editor.getText());
                    try {
                        this.current.save();
                    }
                    catch (Exception e) {
                        Base.showWarning(I18n._("Error"), I18n._("Could not rename the sketch. (0)"), e);
                        return;
                    }
                }
                if (!this.current.renameTo(newFile, newExtension)) {
                    Base.showWarning(I18n._("Error"), I18n.format(I18n._("Could not rename \"{0}\" to \"{1}\""), this.current.getFileName(), newFile.getName()), null);
                    return;
                }
                try {
                    for (int i = 1; i < this.codeCount; ++i) {
                        this.code[i].save();
                    }
                }
                catch (Exception e) {
                    Base.showWarning(I18n._("Error"), I18n._("Could not rename the sketch. (1)"), e);
                    return;
                }
                boolean success = this.folder.renameTo(newFolder);
                if (!success) {
                    Base.showWarning(I18n._("Error"), I18n._("Could not rename the sketch. (2)"), null);
                    return;
                }
                File newMainFile = new File(newFolder, newName + ".ino");
                String newMainFilePath = newMainFile.getAbsolutePath();
                this.editor.handleOpenUnchecked(newMainFilePath, this.currentIndex, this.editor.getSelectionStart(), this.editor.getSelectionStop(), this.editor.getScrollPosition());
                this.editor.base.rebuildSketchbookMenus();
            } else if (!this.current.renameTo(newFile, newExtension)) {
                Base.showWarning(I18n._("Error"), I18n.format(I18n._("Could not rename \"{0}\" to \"{1}\""), this.current.getFileName(), newFile.getName()), null);
                return;
            }
        } else {
            try {
                if (!newFile.createNewFile()) {
                    throw new IOException(I18n._("createNewFile() returned false"));
                }
            }
            catch (IOException e) {
                Base.showWarning(I18n._("Error"), I18n.format("Could not create the file \"{0}\" in \"{1}\"", newFile, this.folder.getAbsolutePath()), e);
                return;
            }
            SketchCode newCode = new SketchCode(newFile, newExtension);
            this.insertCode(newCode);
        }
        this.sortCode();
        this.setCurrentCode(newName);
        this.editor.header.rebuild();
    }

    public void handleDeleteCode() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage(I18n._("Sketch is Read-Only"), I18n._("Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again."));
            return;
        }
        Object[] options = new Object[]{I18n._("OK"), I18n._("Cancel")};
        String prompt = this.currentIndex == 0 ? I18n._("Are you sure you want to delete this sketch?") : I18n.format(I18n._("Are you sure you want to delete \"{0}\"?"), this.current.getPrettyName());
        int result = JOptionPane.showOptionDialog(this.editor, prompt, I18n._("Delete"), 0, 3, null, options, options[0]);
        if (result == 0) {
            if (this.currentIndex == 0) {
                Base.removeDir(this.folder);
                this.editor.base.handleClose(this.editor);
            } else {
                if (!this.current.deleteFile()) {
                    Base.showMessage(I18n._("Couldn't do it"), I18n.format(I18n._("Could not delete \"{0}\"."), this.current.getFileName()));
                    return;
                }
                this.removeCode(this.current);
                this.setCurrentCode(0);
                this.editor.header.repaint();
            }
        }
    }

    protected void removeCode(SketchCode which) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (this.code[i] != which) continue;
            for (int j = i; j < this.codeCount - 1; ++j) {
                this.code[j] = this.code[j + 1];
            }
            --this.codeCount;
            this.code = (SketchCode[])PApplet.shorten((Object)this.code);
            return;
        }
        System.err.println(I18n._("removeCode: internal error.. could not find code"));
    }

    public void handlePrevCode() {
        int prev = this.currentIndex - 1;
        if (prev < 0) {
            prev = this.codeCount - 1;
        }
        this.setCurrentCode(prev);
    }

    public void handleNextCode() {
        this.setCurrentCode((this.currentIndex + 1) % this.codeCount);
    }

    public void setModified(boolean state) {
        this.current.setModified(state);
        this.calcModified();
    }

    protected void calcModified() {
        this.modified = false;
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].isModified()) continue;
            this.modified = true;
            break;
        }
        this.editor.header.repaint();
        if (Base.isMacOS()) {
            Boolean modifiedParam = this.modified ? Boolean.TRUE : Boolean.FALSE;
            this.editor.getRootPane().putClientProperty("windowModified", modifiedParam);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean save() throws IOException {
        this.ensureExistence();
        if (this.current.isModified()) {
            this.current.setProgram(this.editor.getText());
        }
        if (this.isReadOnly()) {
            Base.showMessage(I18n._("Sketch is read-only"), I18n._("Some files are marked \"read-only\", so you'll\nneed to re-save this sketch to another location."));
            if (!this.saveAs()) {
                return false;
            }
        } else {
            File mainFile = new File(this.getMainFilePath());
            File mainFolder = mainFile.getParentFile();
            File[] pdeFiles = mainFolder.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".pde");
                }
            });
            if (pdeFiles != null && pdeFiles.length > 0) {
                if (Preferences.get("editor.update_extension") == null) {
                    Object[] options = new Object[]{I18n._("OK"), I18n._("Cancel")};
                    int result = JOptionPane.showOptionDialog(this.editor, I18n._("In Arduino 1.0, the default file extension has changed\nfrom .pde to .ino.  New sketches (including those created\nby \"Save-As\" will use the new extension.  The extension\nof existing sketches will be updated on save, but you can\ndisable this in the Preferences dialog.\n\nSave sketch and update its extension?"), I18n._(".pde -> .ino"), 2, 3, null, options, options[0]);
                    if (result != 0) {
                        return false;
                    }
                    Preferences.setBoolean("editor.update_extension", true);
                }
                if (Preferences.getBoolean("editor.update_extension")) {
                    for (File pdeFile : pdeFiles) {
                        this.renameCodeToInoExtension(pdeFile);
                    }
                }
            }
        }
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].isModified()) continue;
            this.code[i].save();
        }
        this.calcModified();
        return true;
    }

    protected boolean renameCodeToInoExtension(File pdeFile) {
        for (SketchCode c : this.code) {
            if (!c.getFile().equals(pdeFile)) continue;
            String pdeName = pdeFile.getPath();
            pdeName = pdeName.substring(0, pdeName.length() - 4) + ".ino";
            return c.renameTo(new File(pdeName), "ino");
        }
        return false;
    }

    protected boolean saveAs() throws IOException {
        File customHtml;
        File newFile;
        String newParentDir = null;
        String newName = null;
        FileDialog fd = new FileDialog((Frame)this.editor, I18n._("Save sketch folder as..."), 1);
        if (this.isReadOnly() || this.isUntitled()) {
            fd.setDirectory(Preferences.get("sketchbook.path"));
        } else {
            fd.setDirectory(this.folder.getParent());
        }
        String oldName = this.folder.getName();
        fd.setFile(oldName);
        fd.setVisible(true);
        newParentDir = fd.getDirectory();
        newName = fd.getFile();
        if (newName == null) {
            return false;
        }
        newName = Sketch.checkName(newName);
        File newFolder = new File(newParentDir, newName);
        for (int i = 1; i < this.codeCount; ++i) {
            if (!newName.equalsIgnoreCase(this.code[i].getPrettyName()) || !this.code[i].getExtension().equalsIgnoreCase("cpp")) continue;
            Base.showMessage(I18n._("Nope"), I18n.format(I18n._("You can't save the sketch as \"{0}\"\nbecause the sketch already has a .cpp file with that name."), newName));
            return false;
        }
        if (newFolder.equals(this.folder)) {
            return this.save();
        }
        try {
            String newPath = newFolder.getCanonicalPath() + File.separator;
            String oldPath = this.folder.getCanonicalPath() + File.separator;
            if (newPath.indexOf(oldPath) == 0) {
                Base.showWarning(I18n._("How very Borges of you"), I18n._("You cannot save the sketch into a folder\ninside itself. This would go on forever."), null);
                return false;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (newFolder.exists()) {
            Base.removeDir(newFolder);
        }
        newFolder.mkdirs();
        if (this.current.isModified()) {
            this.current.setProgram(this.editor.getText());
        }
        for (int i = 1; i < this.codeCount; ++i) {
            newFile = new File(newFolder, this.code[i].getFileName());
            this.code[i].saveAs(newFile);
        }
        if (this.dataFolder.exists()) {
            File newDataFolder = new File(newFolder, "data");
            Base.copyDir(this.dataFolder, newDataFolder);
        }
        if (this.codeFolder.exists()) {
            File newCodeFolder = new File(newFolder, "code");
            Base.copyDir(this.codeFolder, newCodeFolder);
        }
        if ((customHtml = new File(this.folder, "applet.html")).exists()) {
            File newHtml = new File(newFolder, "applet.html");
            Base.copyFile(customHtml, newHtml);
        }
        newFile = new File(newFolder, newName + ".ino");
        this.code[0].saveAs(newFile);
        this.editor.handleOpenUnchecked(newFile.getPath(), this.currentIndex, this.editor.getSelectionStart(), this.editor.getSelectionStop(), this.editor.getScrollPosition());
        this.editor.base.rebuildSketchbookMenus();
        this.setUntitled(false);
        return true;
    }

    public void handleAddFile() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage(I18n._("Sketch is Read-Only"), I18n._("Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again."));
            return;
        }
        String prompt = I18n._("Select an image or other data file to copy to your sketch");
        FileDialog fd = new FileDialog((Frame)this.editor, prompt, 0);
        fd.setVisible(true);
        String directory = fd.getDirectory();
        String filename = fd.getFile();
        if (filename == null) {
            return;
        }
        File sourceFile = new File(directory, filename);
        boolean result = this.addFile(sourceFile);
        if (result) {
            this.editor.statusNotice(I18n._("One file added to the sketch."));
        }
    }

    public boolean addFile(File sourceFile) {
        boolean muchSuccess;
        String filename = sourceFile.getName();
        File destFile = null;
        String codeExtension = null;
        boolean replacement = false;
        if (filename.toLowerCase().endsWith(".o") || filename.toLowerCase().endsWith(".a") || filename.toLowerCase().endsWith(".so")) {
            this.prepareCodeFolder();
            destFile = new File(this.codeFolder, filename);
        } else {
            for (String extension : this.getExtensions()) {
                String lower = filename.toLowerCase();
                if (!lower.endsWith("." + extension)) continue;
                destFile = new File(this.folder, filename);
                codeExtension = extension;
            }
            if (codeExtension == null) {
                this.prepareDataFolder();
                destFile = new File(this.dataFolder, filename);
            }
        }
        if (destFile.exists()) {
            Object[] options = new Object[]{I18n._("OK"), I18n._("Cancel")};
            String prompt = I18n.format(I18n._("Replace the existing version of {0}?"), filename);
            int result = JOptionPane.showOptionDialog(this.editor, prompt, I18n._("Replace"), 0, 3, null, options, options[0]);
            if (result == 0) {
                replacement = true;
            } else {
                return false;
            }
        }
        if (replacement && !(muchSuccess = destFile.delete())) {
            Base.showWarning(I18n._("Error adding file"), I18n.format(I18n._("Could not delete the existing ''{0}'' file."), filename), null);
            return false;
        }
        if (codeExtension == null && sourceFile.equals(destFile)) {
            Base.showWarning(I18n._("You can't fool me"), I18n._("This file has already been copied to the\nlocation from which where you're trying to add it.\nI ain't not doin nuthin'."), null);
            return false;
        }
        if (!sourceFile.equals(destFile)) {
            try {
                Base.copyFile(sourceFile, destFile);
            }
            catch (IOException e) {
                Base.showWarning(I18n._("Error adding file"), I18n.format(I18n._("Could not add ''{0}'' to the sketch."), filename), e);
                return false;
            }
        }
        if (codeExtension != null) {
            SketchCode newCode = new SketchCode(destFile, codeExtension);
            if (replacement) {
                this.replaceCode(newCode);
            } else {
                this.insertCode(newCode);
                this.sortCode();
            }
            this.setCurrentCode(filename);
            this.editor.header.repaint();
            if (this.editor.untitled) {
                this.current.setModified(true);
            }
        } else if (this.editor.untitled) {
            this.code[0].setModified(true);
        }
        return true;
    }

    public void importLibrary(String jarPath) throws IOException {
        this.ensureExistence();
        String[] list = Compiler.headerListFromIncludePath(jarPath);
        if (this.hasDefaultExtension(this.current)) {
            this.setCurrentCode(0);
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            buffer.append("#include <");
            buffer.append(list[i]);
            buffer.append(">\n");
        }
        buffer.append('\n');
        buffer.append(this.editor.getText());
        this.editor.setText(buffer.toString());
        this.editor.setSelection(0, 0);
        this.setModified(true);
    }

    public void setCurrentCode(int which) {
        if (this.currentIndex == which && this.current != null) {
            return;
        }
        if (this.current != null) {
            this.current.setState(this.editor.getText(), this.editor.getSelectionStart(), this.editor.getSelectionStop(), this.editor.getScrollPosition());
        }
        this.current = this.code[which];
        this.currentIndex = which;
        this.editor.setCode(this.current);
        this.editor.header.rebuild();
    }

    protected void setCurrentCode(String findName) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (!findName.equals(this.code[i].getFileName()) && !findName.equals(this.code[i].getPrettyName())) continue;
            this.setCurrentCode(i);
            return;
        }
    }

    protected void cleanup() {
        System.gc();
        if (deleteFilesOnNextBuild) {
            Base.removeDescendants(tempBuildFolder);
            deleteFilesOnNextBuild = false;
        } else if (tempBuildFolder.exists()) {
            String[] files;
            for (String file : files = tempBuildFolder.list()) {
                File deleteMe;
                if (!file.endsWith(".c") && !file.endsWith(".cpp") && !file.endsWith(".s") || (deleteMe = new File(tempBuildFolder, file)).delete()) continue;
                System.err.println("Could not delete " + deleteMe);
            }
        }
    }

    public static void buildSettingChanged() {
        deleteFilesOnNextBuild = true;
    }

    public void prepare() {
        this.ensureExistence();
        this.current.setProgram(this.editor.getText());
        if (Preferences.getBoolean("editor.external")) {
            this.current = null;
            this.load();
        }
        this.cleanup();
    }

    public String preprocess(String buildPath) throws RunnerException {
        return this.preprocess(buildPath, new PdePreprocessor());
    }

    public String preprocess(String buildPath, PdePreprocessor preprocessor) throws RunnerException {
        this.ensureExistence();
        String[] codeFolderPackages = null;
        this.classPath = buildPath;
        StringBuffer bigCode = new StringBuffer();
        int bigCount = 0;
        for (SketchCode sc : this.code) {
            if (!sc.isExtension("ino") && !sc.isExtension("pde")) continue;
            sc.setPreprocOffset(bigCount);
            bigCode.append("#line 1 \"" + sc.getFileName() + "\"\n");
            bigCode.append(sc.getProgram());
            bigCode.append('\n');
            bigCount += sc.getLineCount();
        }
        int headerOffset = 0;
        try {
            headerOffset = preprocessor.writePrefix(bigCode.toString(), buildPath, this.name, codeFolderPackages);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            String msg = I18n._("Build folder disappeared or could not be written");
            throw new RunnerException(msg);
        }
        String primaryClassName = null;
        try {
            String className = preprocessor.write();
            if (className == null) {
                throw new RunnerException(I18n._("Could not find main class"));
            }
            primaryClassName = className + ".cpp";
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            String msg = I18n._("Build folder disappeared or could not be written");
            throw new RunnerException(msg);
        }
        catch (RunnerException pe) {
            throw pe;
        }
        catch (Exception ex) {
            System.err.println(I18n.format(I18n._("Uncaught exception type: {0}"), ex.getClass()));
            ex.printStackTrace();
            throw new RunnerException(ex.toString());
        }
        this.importedLibraries = new ArrayList();
        for (String item : preprocessor.getExtraImports()) {
            File libFolder = Base.importToLibraryTable.get(item);
            if (libFolder == null || this.importedLibraries.contains(libFolder)) continue;
            this.importedLibraries.add(libFolder);
            this.libraryPath = this.libraryPath + File.pathSeparator + libFolder.getAbsolutePath();
        }
        for (SketchCode sc : this.code) {
            if (sc.isExtension("c") || sc.isExtension("cpp") || sc.isExtension("h")) {
                String filename = sc.getFileName();
                try {
                    Base.saveFile(sc.getProgram(), new File(buildPath, filename));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RunnerException(I18n.format(I18n._("Problem moving {0} to the build folder"), filename));
                }
            }
            if (!sc.isExtension("ino") && !sc.isExtension("pde")) continue;
            sc.addPreprocOffset(headerOffset);
        }
        return primaryClassName;
    }

    public ArrayList<File> getImportedLibraries() {
        return this.importedLibraries;
    }

    public RunnerException placeException(String message, String dotJavaFilename, int dotJavaLine) {
        for (int codeIndex = 0; codeIndex < this.getCodeCount(); ++codeIndex) {
            SketchCode code = this.getCode(codeIndex);
            if (!dotJavaFilename.equals(code.getFileName())) continue;
            return new RunnerException(message, codeIndex, dotJavaLine);
        }
        return null;
    }

    public String build(boolean verbose) throws RunnerException {
        return this.build(tempBuildFolder.getAbsolutePath(), verbose);
    }

    public String build(String buildPath, boolean verbose) throws RunnerException {
        this.editor.status.progressUpdate(20);
        String primaryClassName = this.preprocess(buildPath);
        Compiler compiler = new Compiler();
        if (compiler.compile(this, buildPath, primaryClassName, verbose)) {
            this.size(buildPath, primaryClassName);
            return primaryClassName;
        }
        return null;
    }

    protected boolean exportApplet(boolean usingProgrammer) throws Exception {
        return this.exportApplet(tempBuildFolder.getAbsolutePath(), usingProgrammer);
    }

    public boolean exportApplet(String appletPath, boolean usingProgrammer) throws RunnerException, IOException, SerialException {
        this.prepare();
        this.editor.status.progressNotice(I18n._("Compiling sketch..."));
        String foundName = this.build(appletPath, false);
        if (foundName == null) {
            return false;
        }
        this.editor.status.progressNotice(I18n._("Uploading..."));
        this.upload(appletPath, foundName, usingProgrammer);
        this.editor.status.progressUpdate(100);
        return true;
    }

    public void setCompilingProgress(int percent) {
        this.editor.status.progressUpdate(percent);
    }

    protected void size(String buildPath, String suggestedClassName) throws RunnerException {
        long size = 0L;
        String maxsizeString = Base.getBoardPreferences().get("upload.maximum_size");
        if (maxsizeString == null) {
            return;
        }
        long maxsize = Integer.parseInt(maxsizeString);
        Sizer sizer = new Sizer(buildPath, suggestedClassName);
        try {
            size = sizer.computeSize();
            System.out.println(I18n.format(I18n._("Binary sketch size: {0} bytes (of a {1} byte maximum)"), size, maxsize));
        }
        catch (RunnerException e) {
            System.err.println(I18n.format(I18n._("Couldn't determine program size: {0}"), e.getMessage()));
        }
        if (size > maxsize) {
            throw new RunnerException(I18n._("Sketch too big; see http://www.arduino.cc/en/Guide/Troubleshooting#size for tips on reducing it."));
        }
    }

    protected String upload(String buildPath, String suggestedClassName, boolean usingProgrammer) throws RunnerException, SerialException {
        AvrdudeUploader uploader = new AvrdudeUploader();
        boolean success = ((Uploader)uploader).uploadUsingPreferences(buildPath, suggestedClassName, usingProgrammer);
        return success ? suggestedClassName : null;
    }

    public static String scrubComments(String what) {
        char[] p = what.toCharArray();
        int index = 0;
        while (index < p.length) {
            if (p[index] == '/' && index < p.length - 1 && p[index + 1] == '/') {
                p[index++] = 32;
                p[index++] = 32;
                while (index < p.length && p[index] != '\n') {
                    p[index++] = 32;
                }
                continue;
            }
            if (p[index] == '/' && index < p.length - 1 && p[index + 1] == '*') {
                p[index++] = 32;
                p[index++] = 32;
                boolean endOfRainbow = false;
                while (index < p.length - 1) {
                    if (p[index] == '*' && p[index + 1] == '/') {
                        p[index++] = 32;
                        p[index++] = 32;
                        endOfRainbow = true;
                        break;
                    }
                    p[index++] = 32;
                }
                if (endOfRainbow) continue;
                throw new RuntimeException(I18n._("Missing the */ from the end of a /* comment */"));
            }
            ++index;
        }
        return new String(p);
    }

    public boolean exportApplicationPrompt() throws IOException, RunnerException {
        return false;
    }

    protected boolean exportApplication() throws IOException, RunnerException {
        return false;
    }

    public boolean exportApplication(String destPath, int exportPlatform) throws IOException, RunnerException {
        return false;
    }

    protected void ensureExistence() {
        if (this.folder.exists()) {
            return;
        }
        Base.showWarning(I18n._("Sketch Disappeared"), I18n._("The sketch folder has disappeared.\n Will attempt to re-save in the same location,\nbut anything besides the code will be lost."), null);
        try {
            this.folder.mkdirs();
            this.modified = true;
            for (int i = 0; i < this.codeCount; ++i) {
                this.code[i].save();
            }
            this.calcModified();
        }
        catch (Exception e) {
            Base.showWarning(I18n._("Could not re-save sketch"), I18n._("Could not properly re-save the sketch. You may be in trouble at this point,\nand it might be time to copy and paste your code to another text editor."), e);
        }
    }

    public boolean isReadOnly() {
        String apath = this.folder.getAbsolutePath();
        if (apath.startsWith(Base.getExamplesPath()) || apath.startsWith(Base.getLibrariesPath()) || apath.startsWith(Base.getSketchbookLibrariesPath())) {
            return true;
        }
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].isModified() || !this.code[i].fileReadOnly() || !this.code[i].fileExists()) continue;
            return true;
        }
        return false;
    }

    public boolean hideExtension(String what) {
        return this.getHiddenExtensions().contains(what);
    }

    public boolean hasDefaultExtension(SketchCode code) {
        return code.getExtension().equals(this.getDefaultExtension());
    }

    public boolean isDefaultExtension(String what) {
        return what.equals(this.getDefaultExtension());
    }

    public boolean validExtension(String what) {
        String[] ext = this.getExtensions();
        for (int i = 0; i < ext.length; ++i) {
            if (!ext[i].equals(what)) continue;
            return true;
        }
        return false;
    }

    public String getDefaultExtension() {
        return "ino";
    }

    public List<String> getHiddenExtensions() {
        return hiddenExtensions;
    }

    public String[] getExtensions() {
        return new String[]{"ino", "pde", "c", "cpp", "h"};
    }

    public String getName() {
        return this.name;
    }

    public File getPrimaryFile() {
        return this.primaryFile;
    }

    public String getMainFilePath() {
        return this.primaryFile.getAbsolutePath();
    }

    public File getFolder() {
        return this.folder;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public File prepareDataFolder() {
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        return this.dataFolder;
    }

    public File getCodeFolder() {
        return this.codeFolder;
    }

    public File prepareCodeFolder() {
        if (!this.codeFolder.exists()) {
            this.codeFolder.mkdirs();
        }
        return this.codeFolder;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public SketchCode[] getCode() {
        return this.code;
    }

    public int getCodeCount() {
        return this.codeCount;
    }

    public SketchCode getCode(int index) {
        return this.code[index];
    }

    public int getCodeIndex(SketchCode who) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (who != this.code[i]) continue;
            return i;
        }
        return -1;
    }

    public SketchCode getCurrentCode() {
        return this.current;
    }

    public void setUntitled(boolean u) {
        this.editor.untitled = u;
    }

    public boolean isUntitled() {
        return this.editor.untitled;
    }

    public String getAppletClassName2() {
        return this.appletClassName;
    }

    public static String checkName(String origName) {
        String newName = Sketch.sanitizeName(origName);
        if (!newName.equals(origName)) {
            String msg = I18n._("The sketch name had to be modified. Sketch names can only consist\nof ASCII characters and numbers (but cannot start with a number).\nThey should also be less less than 64 characters long.");
            System.out.println(msg);
        }
        return newName;
    }

    public static boolean isSanitaryName(String name) {
        return Sketch.sanitizeName(name).equals(name);
    }

    public static String sanitizeName(String origName) {
        char[] c = origName.toCharArray();
        StringBuffer buffer = new StringBuffer();
        if (c[0] >= '0' && c[0] <= '9') {
            buffer.append('_');
        }
        for (int i = 0; i < c.length; ++i) {
            if (c[i] >= '0' && c[i] <= '9' || c[i] >= 'a' && c[i] <= 'z' || c[i] >= 'A' && c[i] <= 'Z') {
                buffer.append(c[i]);
                continue;
            }
            buffer.append('_');
        }
        if (buffer.length() > 63) {
            buffer.setLength(63);
        }
        return buffer.toString();
    }

    static {
        deleteFilesOnNextBuild = true;
        hiddenExtensions = Arrays.asList("ino", "pde");
    }
}

